// Backend API URLs - Server Deployment
export const RENTAL_URL = "http://46.62.135.60:8080";
export const PROPETY_LIST_URL = "http://46.62.135.60:8081/propertylist";
export const USER_MANAGEMENT_URL = "http://46.62.135.60:8082/api/users";

export function redirectToLoginPage() {
  const userInfo = JSON.parse(localStorage.getItem("userInfo"));
  if (!userInfo) window.location.href = "/admin/auth/login.html";
}

export function enforcePanelAccess() {
  const userInfo = JSON.parse(localStorage.getItem("userInfo") || "{}");
  const currentPath = window.location.pathname.toLowerCase();

  const RENTAL_ROLES = ["ROLE_RENT_PUBLISHER", "ROLE_RENTAL_SEARCH"];
  const PROPERTY_ROLES = ["ROLE_SALES_PUBLISHER", "ROLE_PROPERTY_SEARCH"];
  const SUPER_ROLES = ["ROLE_ADMIN", "ROLE_SUPERADMIN"];

  if (!userInfo.roles) {
    // No roles = kick to login
    window.location.href = "/login.html";
    return;
  }

  const roles = userInfo.roles;
  const isSuper = roles.some((r) => SUPER_ROLES.includes(r));
  const hasRental = isSuper || roles.some((r) => RENTAL_ROLES.includes(r));
  const hasProperty = isSuper || roles.some((r) => PROPERTY_ROLES.includes(r));

  // ✅ If URL contains rental
  if (currentPath.includes("/admin/rental/")) {
    if (!hasRental) {
      // Forbidden: redirect them into property list equivalent
      const redirectPath = currentPath.replace(
        "/admin/rental/",
        "/admin/property-list/"
      );
      window.location.replace(redirectPath);
      return;
    }
  }

  // ✅ If URL contains property-list
  if (currentPath.includes("/admin/property-list/")) {
    if (!hasProperty) {
      // Forbidden: redirect them into rental equivalent
      const redirectPath = currentPath.replace(
        "/admin/property-list/",
        "/admin/rental/"
      );
      window.location.replace(redirectPath);
      return;
    }
  }

  // ✅ If URL contains organization-management
  if (currentPath.includes("/admin/organization-management/")) {
    const isSuperAdmin = roles.some((r) => r === "ROLE_SUPERADMIN");
    if (!isSuperAdmin) {
      // Forbidden: redirect to dashboard
      window.location.replace("/admin/rental/dashboard.html");
      return;
    }
  }

  // ✅ Otherwise: access allowed
  console.log("Access granted to:", currentPath);
}

export async function getCurrentUser(token) {
  try {
    const response = await fetch(`${USER_MANAGEMENT_URL}/me`, {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
    });

    if (!response.ok) {
      // if status is not 200–299
      const errorText = await response.text();
      throw new Error(errorText || "Failed to fetch user");
    }

    const data = await response.json();

    return data;
  } catch (error) {
    throw new Error(error.message || "Failed to fetch user");
  }
}
