import "../notifications/toastr/toastr.js";
import "../notifications/sweetalert2/sweetalert2.bundle.js";

export function showToast(type = "info", message = "", title = "") {
  toastr.options = {
    closeButton: true,
    progressBar: true,
    positionClass: "toast-top-full-width",
    timeOut: 3000,
    extendedTimeOut: 1000,
    showEasing: "swing",
    hideEasing: "linear",
    showMethod: "fadeIn",
    hideMethod: "fadeOut",
    newestOnTop: true,
    preventDuplicates: true,
  };

  toastr[type](message, title);
}

export function alert() {
  return Swal.fire({
    title: "Are you sure?",
    text: "You won't be able to revert this!",
    type: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
  });
}

export function showAlert(message, type) {
  const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show slide-down" role="alert" style="
                position: fixed;
                top: 20px;
                left: 50%;
                transform: translateX(-50%);
                z-index: 9999;
                width: 70%;
                text-align: center;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                opacity: 0;
                animation: slideFromTop 0.5s ease-out forwards;
            ">
                ${message}
                <button type="button" class="close" data-dismiss="alert">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <style>
                @keyframes slideFromTop {
                    from {
                        transform: translate(-50%, -100%);
                        opacity: 0;
                    }
                    to {
                        transform: translate(-50%, 0);
                        opacity: 1;
                    }
                }
            </style>
        `;

  // Insert alert at the beginning of the body
  document.body.insertAdjacentHTML("afterbegin", alertHtml);

  // Auto-remove alert after 5 seconds
  setTimeout(() => {
    const alert = document.querySelector(".alert");
    if (alert) {
      alert.remove();
    }
  }, 5000);
}
