# User Management System - Admin Documentation

## Overview

This User Management System provides a comprehensive administrative interface for managing users, roles, permissions, and organizations. The system implements a sophisticated Role-Based Access Control (RBAC) system with multiple administrative levels.

---

## User Roles and Permissions

### 1. Super Admin (ROLE_SUPERADMIN)
**Highest level of access - Full system control**

**Capabilities:**
- View all users across all organizations
- Create, edit, and delete any user
- Manage user roles and permissions
- Grant delete permissions to System Admins
- Block/unblock users (including Organization Super Admins)
- Remove System Admin roles
- Change user roles (promote/demote users)
- Manage organizations
- No restrictions on data access

**Limitations:**
- Cannot delete themselves
- Cannot change their own roles
- Cannot block themselves

---

### 2. System Admin (ROLE_SYSTEM_ADMIN)
**Second-highest level - Almost full access**

**Capabilities:**
- View all users (unless restricted by organization)
- Create and edit users
- Enable/disable users
- Manage user profiles
- All permissions except deleting users (unless granted by Super Admin)

**Special Permissions:**
- **Delete Permission**: Can be granted by Super Admin to allow user deletion
- When granted delete permission, can delete users (except Super Admins)

**Limitations:**
- Cannot delete users unless Super Admin grants delete permission
- Cannot change user roles
- Cannot block users
- Cannot remove System Admin roles

---

### 3. Organization Super Admin (ROLE_ORG_SUPERADMIN)
**Organization-level administrator**

**Capabilities:**
- View only users from their organization
- Create users within their organization
- Edit users within their organization
- Delete users within their organization
- Manage users under their organization
- One Organization Super Admin per organization

**Limitations:**
- Cannot view users from other organizations
- Cannot create users without an organization
- Cannot manage users outside their organization
- Cannot change user roles
- Cannot block users

**Special Behavior:**
- Automatically assigned when Super Admin creates an Admin user with an organization
- If blocked by Super Admin, all users under the organization are also blocked

---

### 4. Normal Admin (ROLE_NORMAL_ADMIN)
**Limited administrative access**

**Capabilities:**
- View only users from their organization
- Edit their own profile
- View organization data

**Limitations:**
- **Cannot add new users**
- Cannot delete users
- Cannot edit other users
- Cannot change user roles
- Cannot manage permissions

---

### 5. Other Roles
- **ROLE_ADMIN**: General admin role
- **ROLE_RENT_PUBLISHER**: Can publish rental properties
- **ROLE_SALES_PUBLISHER**: Can publish sales properties
- **ROLE_RENTAL_SEARCH**: Can search rental properties
- **ROLE_PROPERTY_SEARCH**: Can search properties

---

## Key Features

### 1. User Management

#### Adding Users
**Who can add users:**
- Super Admin
- System Admin
- Organization Super Admin

**Steps:**
1. Click the "Add User" button
2. Fill in required information:
   - Username (required)
   - Email (required)
   - Password (required)
   - Confirm Password (required)
   - Organization (required for Organization Super Admin role)
   - Select user roles
3. Click "Add User"

**Important Notes:**
- When creating an Admin user with an organization, they automatically become Organization Super Admin
- Only one Organization Super Admin per organization
- Organization must be selected when assigning Organization Super Admin role

#### Editing Users
**Who can edit:**
- Super Admin: Can edit any user
- System Admin: Can edit any user
- Organization Super Admin: Can edit users in their organization
- Normal Admin: Can only edit their own profile
- Regular users: Can only edit their own profile

**Steps:**
1. Click the "Edit" button (pencil icon) next to the user
2. Modify user details
3. Click "Save Changes"

#### Viewing User Details
**How to view:**
- Click anywhere on a user row (except checkboxes and action buttons)
- Or click the "View" button (eye icon)

**Information displayed:**
- User ID
- Username
- Email
- Full Name
- NIC
- Phone Number
- Status (Active/Inactive/Blocked)
- Organization
- Roles

#### Deleting Users
**Who can delete:**
- Super Admin: Can delete any user (except themselves)
- System Admin: Can delete users only if Super Admin granted delete permission

**Steps:**
1. Click the "Delete" button (trash icon) next to the user
2. Confirm deletion in the popup

**Important:**
- Cannot delete Super Admin users
- Cannot delete yourself
- Bulk delete available for Super Admin

---

### 2. Permission Management

#### Managing User Permissions (Super Admin Only)
**Steps:**
1. Click the "Manage Permissions" button (user-cog icon)
2. In the modal:
   - Select/deselect roles
   - Grant delete permission (for System Admins)
   - Block/unblock user
   - Select organization (if Organization Super Admin role is selected)
3. Click "Update Roles" to save changes

**Features:**
- Change user roles dynamically
- Grant/revoke delete permissions for System Admins
- Block/unblock users
- Remove System Admin role

#### Blocking Users (Super Admin Only)
**Steps:**
1. Open "Manage Permissions" modal
2. Toggle the "Block User" switch
3. Click "Update Block Status"

**Important:**
- Blocking an Organization Super Admin also blocks all users under that organization
- Blocked users cannot log in
- Cannot block yourself
- Cannot block Super Admin users

---

### 3. Search and Filter

#### Search Users
**Available filters:**
- Username
- First Name
- Last Name
- NIC
- Status (Active/Inactive/All)
- Organization (searchable dropdown)

**Steps:**
1. Enter search criteria in the filter fields
2. Click "Search Users"
3. Use "Clear Filters" to reset

**Features:**
- Real-time filtering
- Searchable organization dropdown
- Multiple filter combinations
- Results update automatically

---

### 4. Bulk Operations

#### Bulk Enable/Disable
**Who can use:**
- Super Admin
- System Admin
- Organization Super Admin

**Steps:**
1. Select users using checkboxes
2. Click "Bulk Enable" or "Bulk Disable"
3. Confirm the action

#### Bulk Delete
**Who can use:**
- Super Admin only
- System Admin with delete permission

**Steps:**
1. Select users using checkboxes
2. Click "Bulk Delete"
3. Confirm deletion

---

### 5. Organization Management

#### Organization Selection
**Features:**
- Searchable dropdown menu
- Type to filter organizations
- Shows organization name and code
- Required for Organization Super Admin role

**How to use:**
1. Click on organization field
2. Type to search
3. Select from filtered results

---

## User Status

### Active
- User can log in
- User can access the system
- Green badge indicator

### Inactive
- User cannot log in
- Account is disabled
- Red badge indicator

### Blocked
- User cannot log in
- Account is blocked by Super Admin
- Red badge with "Blocked" text
- If Organization Super Admin is blocked, all organization users are blocked

---

## Table Features

### Column Visibility
- Click "Column Visibility" button
- Show/hide columns as needed
- Email column is hidden by default

### Sorting
- Click column headers to sort
- Up/down arrows indicate sort direction
- Multiple column sorting supported

### Pagination
- Navigate through pages
- Change items per page
- Shows total number of users

### Export Options
- **CSV**: Export table data to CSV file
- **Copy**: Copy table data to clipboard
- **Print**: Print table data

---

## Security Features

### Authentication
- JWT token-based authentication
- Token stored in browser localStorage
- Automatic token validation

### Authorization
- Role-based access control
- Permission checks on all operations
- Organization-based data filtering

### Data Protection
- Users can only see data they're authorized to view
- Organization-based data isolation
- Secure API endpoints

---

## Common Workflows

### Creating an Organization Super Admin
1. Log in as Super Admin
2. Click "Add User"
3. Fill in user details
4. Select "Organization Super Admin" role
5. **Select an organization** (required)
6. Click "Add User"

### Granting Delete Permission to System Admin
1. Log in as Super Admin
2. Find the System Admin user
3. Click "Manage Permissions"
4. Check "Grant Delete Permission"
5. Click "Update Delete Permission"

### Blocking an Organization
1. Log in as Super Admin
2. Find the Organization Super Admin
3. Click "Manage Permissions"
4. Toggle "Block User" switch
5. Click "Update Block Status"
6. All users under that organization will be blocked

### Changing User Roles
1. Log in as Super Admin
2. Find the user
3. Click "Manage Permissions"
4. Select/deselect roles
5. If selecting Organization Super Admin, select organization
6. Click "Update Roles"

---

## Best Practices

1. **Organization Management**
   - Assign one Organization Super Admin per organization
   - Ensure organization is selected when creating Organization Super Admin

2. **User Permissions**
   - Grant delete permissions only to trusted System Admins
   - Regularly review user roles and permissions

3. **Security**
   - Never share Super Admin credentials
   - Use strong passwords
   - Regularly audit user access

4. **Data Management**
   - Use search and filters to find users quickly
   - Export data regularly for backup
   - Review blocked users periodically

---

## Troubleshooting

### Cannot view users
- Check if you have appropriate role
- Verify organization assignment (for Organization Super Admin)
- Contact Super Admin for access

### Cannot add users
- Verify you have Admin role (Super Admin, System Admin, or Organization Super Admin)
- Normal Admin cannot add users

### Cannot delete users
- Verify you are Super Admin or System Admin with delete permission
- Check if user is Super Admin (cannot be deleted)

### Organization dropdown not showing
- Ensure you have permission to view organizations
- Check if organizations exist in the system

---

## Support

For technical support or questions about the User Management System, please contact your system administrator or refer to the technical documentation.

---

**Version:** 1.0  
**Last Updated:** 2024  
**System:** User Management Admin Panel

